<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman backend element view to select a single newsletter for a view in frontend.
 *
 * @version 4.3.5
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2026 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace BoldtWebservice\Component\BwPostman\Administrator\View\Newsletterelement;

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

use Exception;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\String\StringHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;

/**
 * Class BwPostmanViewNewsletterelement
 *
 * @since       1.0.1
 */
class HtmlView extends BaseHtmlView
{
	/**
	 * property to hold selected items
	 *
	 * @var array   $items
	 *
	 * @since       1.0.1
	 */
	protected $items;

	/**
	 * property to hold pagination object
	 *
	 * @var object  $pagination
	 *
	 * @since       1.0.1
	 */
	protected $pagination;

	/**
	 * property to hold mailing lists
	 *
	 * @var array   $lists
	 *
	 * @since       1.0.1
	 */
	protected $lists;

	/**
	 * property to hold user object
	 *
	 * @var object  $user
	 *
	 * @since       1.0.1
	 */
	protected $user;

	/**
	 * property to hold request url
	 *
	 * @var string   $request_url
	 *
	 * @since       1.0.1
	 */
	protected $request_url;

	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  HtmlView  A string if successful, otherwise a JError object.
	 *
	 * @throws Exception
	 *
	 * @since       1.0.1
	 */
	public function display($tpl = null): HtmlView
	{
		$app = Factory::getApplication();

		$user		= $app->getIdentity();
		$uri		= Uri::getInstance();
		$uri_string	= str_replace('&', '&amp;', $uri->toString());

		// Build the key for the userState
		$key = $this->getName();

		// Load the ordering, the search and the filters
		$filter_order 		= $app->getUserStateFromRequest($key . '_filter_order', 'filter_order', 'a.subject', 'cmd');
		$filter_order_Dir 	= $app->getUserStateFromRequest($key . '_filter_order_Dir', 'filter_order_Dir', '', 'word');
		$search				= $app->getUserStateFromRequest($key . '_search', 'search', '', 'string');
		$search				= StringHelper::strtolower($search);

		// Set toolbar title
		ToolbarHelper::title(Text::_('COM_BWPOSTMAN_NLS'), 'envelope');

		// Get data from the model
		$items 		= $this->get('data');
		$pagination = $this->get('pagination');

		// Table ordering
		$lists['order'] = $filter_order;
		$lists['order_Dir'] = $filter_order_Dir;

		// Search filter
		$lists['search'] = $search;

		// Save a reference into view
		$this->items        = $items;
		$this->lists        = $lists;
		$this->pagination   = $pagination;
		$this->request_url  = $uri_string;
		$this->user         = $user;

		// Call parent display
		parent::display($tpl);
		return $this;
	}
}//end class
