<?php
/**
 * BwTransifex Component
 *
 * BwTransifex service provider class for the component backend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Admin
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

defined('_JEXEC') or die('Restricted access');

// BwTransifex Administration Component
const BWTRANSIFEX_ADMINISTRATOR = JPATH_ADMINISTRATOR . '/components/com_bwtransifex';
const BWTRANSIFEX_PRO           = '0';
const BWTRANSIFEX_VERSION       = '1.0.0';
const BWTRANSIFEX_DATE          = '2023-05-06';

// BwTransifex Site Component
const BWTRANSIFEX_SITE = JPATH_SITE . '/components/com_bwtransifex';

use Joomla\CMS\Component\Router\RouterFactoryInterface;
use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\Extension\Service\Provider\RouterFactory;
use Joomla\CMS\HTML\Registry;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use BoldtWebservice\Component\BwTransifex\Administrator\Extension\BwTransifexComponent;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

/**
 * Define the BwTransifex service provider class
 *
 * @package BwTransifex Admin
 *
 * @since 1.0.0
 */
return new class implements ServiceProviderInterface
{
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since 1.0.0
     */
    public function register(Container $container): void
    {
        $container->registerServiceProvider(new MVCFactory('\\BoldtWebservice\\Component\\BwTransifex'));
        $container->registerServiceProvider(new ComponentDispatcherFactory('\\BoldtWebservice\\Component\\BwTransifex'));
        $container->registerServiceProvider(new RouterFactory('\\BoldtWebservice\\Component\\BwTransifex'));

        $container->set(
            ComponentInterface::class,
            function (Container $container)
            {
                $component = new BwTransifexComponent($container->get(ComponentDispatcherFactoryInterface::class));

                $component->setRegistry($container->get(Registry::class));
                $component->setMVCFactory($container->get(MVCFactoryInterface::class));
                $component->setRouterFactory($container->get(RouterFactoryInterface::class));

                return $component;
            }
        );
    }
};
