<?php
/**
 * BwTransifex Component
 *
 * BwTransifex table class for the component backend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Admin
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

namespace BoldtWebservice\Component\BwTransifex\Administrator\Table;

// No direct access
defined('_JEXEC') or die('Restricted access');

use Exception;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;
use Joomla\Filter\InputFilter;

/**
 * Define the BwTransifex resource table class
 *
 * @package BwTransifex Admin
 *
 * @since 1.0.0
 */
class ResourceTable extends Table
{
    /**
     * @var int Primary Key
     *
     * @since 1.0.0
     */
    public int $id = 0;

    /**
     * @var int project_id
     *
     * @since 1.0.0
     */
    public int $project_id = 0;

    /**
     * @var string resource_name
     * varchar
     *
     * @since 1.0.0
     */
    public string $resource_name = '';

    /**
     * Constructor
     *
     * @param   DatabaseDriver  $db  Database connector object
     *
     * @since 1.0.0
     */
    public function __construct($db)
    {
        parent::__construct('#__bwtransifex_resources', 'id', $db);
    }

    /**
     * Override Table::check method to ensure data integrity
     *
     * @access public
     *
     * @return boolean True
     *
     * @throws Exception
     *
     * @since 1.0.0
     */
    public function check(): bool
    {
        try {
            // Add event
            parent::check();

            // Sanitize values
            $filter = new InputFilter(array(), array(), 0, 0);

            $this->id            = $filter->clean($this->id, 'UINT');
            $this->resource_id   = $filter->clean($this->resource_id, 'UINT');
            $this->resource_name = $filter->clean($this->resource_name, 'STRING');

            return true;
        }
        catch (Exception $exception)
        {
            throw new Exception($exception);
        }
    }
}

