<?php
/**
 * BwTransifex Component
 *
 * BwTransifex layout 'footer' site
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Site
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die('Restricted access');

$config    = ComponentHelper::getParams('com_bwtransifex');
$bwFooter  = $config->get('bw_footer', 1);
$transifex = $config->get('transifex_footer', 1);
$bwLink    = $config->get('show_boldt_link', 1);

if ($bwFooter || $transifex)
{
    echo '<div class="row-fluid muted small" data-test="bw-fe-footer"><p class="center text-center">';

    if ($bwFooter)
    { ?>
        <span data-test="language-footer-text1">
                    <?php echo Text::_('COM_BWTRANSIFEX_POWERED_BY'); ?>
                </span> <?php

        if ($transifex)
        { ?>
            <span data-test="language-footer-text2">
                    <?php echo ' ' . Text::_('COM_BWTRANSIFEX_USING'); ?>
                </span> <?php
        }
    }

    echo '</p>';
    echo '</div>';
}
