<?php
/**
 * BwTransifex Component
 *
 * BwTransifex template 'project' for the component frontend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Site
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

// Get provided style file
$app = Factory::getApplication();
$wa  = $app->getDocument()->getWebAssetManager();

$wa->useStyle('com_bwtransifex.bwtransifex_site');

if ($this->error) {
    $message = '<span class="bwtx-error-text">' . Text::_('COM_BWTRANSIFEX_LANGUAGE_RESOURCE_NOT_FOUND') . '</span>';
    ?>
    <div class="row-fluid bwtransifex-margin">
        <div data-test="bwtx-error" class="bwtx-error">
            <p><strong><?php echo Text::_('COM_BWTRANSIFEX_LAYOUT_ERROR_HAS_OCCURRED_WHILE_PROCESSING_YOUR_REQUEST'); echo ' ' . $message; ?></strong></p>
            <p><?php echo Text::_('JERROR_LAYOUT_NOT_ABLE_TO_VISIT'); ?></p>
            <ul>
                <li><?php echo Text::_('JERROR_LAYOUT_AN_OUT_OF_DATE_BOOKMARK_FAVOURITE'); ?></li>
                <li><?php echo Text::_('JERROR_LAYOUT_MIS_TYPED_ADDRESS'); ?></li>
                <li><?php echo Text::_('JERROR_LAYOUT_SEARCH_ENGINE_OUT_OF_DATE_LISTING'); ?></li>
                <li><?php echo Text::_('JERROR_LAYOUT_YOU_HAVE_NO_ACCESS_TO_THIS_PAGE'); ?></li>
            </ul>
            <p><?php echo Text::_('COM_BWTRANSIFEX_GO_TO_PROJECTS_LIST'); ?></p>
            <p><a href="<?php echo $this->baseurl; ?>index.php?option=com_bwtransifex&view=projects" class="btn btn-secondary"><span class="icon-home" aria-hidden="true"></span> <?php echo Text::_('COM_BWTRANSIFEX_LAYOUT_PROJECTS_LIST'); ?></a></p>
            <hr>
            <p><?php echo Text::_('JERROR_LAYOUT_PLEASE_CONTACT_THE_SYSTEM_ADMINISTRATOR'); ?></p>
        </div>
    </div>
<?php }
else
{
    // Get user defined style file
    $templateName = $app->getTemplate();
    $css_filename = 'templates/' . $templateName . '/css/com_bwtransifex.css';
    $projectName  = str_replace(' ', '_', $this->item->title);

    if (file_exists(JPATH_BASE . '/' . $css_filename))
    {
        $wa->registerAndUseStyle('customCss', Uri::root() . $css_filename);
    }

    ?>

    <div id="bwtransifex" class="mt">
        <div id="bw_com_project">
            <?php // if project unpublished - only backlink
                if (($this->menuParams->get('show_page_heading', '0') != 0) && ($this->menuParams->get('page_heading', '') != '')) { ?>
                    <h1 class="contentheading<?php echo $this->escape($this->menuParams->get('pageclass_sfx', '')); ?>" data-test="project-page-heading">
                        <?php echo $this->escape($this->menuParams->get('page_heading', '')); ?>
                    </h1>
                    <?php
                    if ($this->page_title)
                    { ?>
                        <h2 data-test="project-header-<?php echo $projectName; ?>">
                            <?php echo Text::printf('COM_BWTRANSIFEX_TRANSLATIONS_FOR_PROJECT', $this->item->title); ?>
                        </h2>
                        <div>
                            <?php echo $this->item->description; ?>
                        </div>
                        <?php
                    } ?>
                    <?php
                }
                else
                { ?>
            <h2 data-test="project-header">
                <?php echo Text::sprintf('COM_BWTRANSIFEX_TRANSLATIONS_FOR_PROJECT', $this->item->title); ?>
            </h2>
            <div data-test="project-desc">
                <?php echo $this->item->description; ?>
            </div>
                    <?php
                } ?>

            <?php if (count($this->languages) > 0) { ?>
            <table class="table" data-test="project-lang-table">
                <?php foreach ($this->languages as $language) :
                    $linkText = '';
                    if (isset($language->iso_lang_name)) :
                        $linkText = ucfirst($language->iso_lang_name);
                     if (isset($language->iso_country_name) && $language->iso_country_name != '') :
                         $linkText.= ' (' . $language->iso_country_name . ')';
                    endif;
                else :
                    $linkText = $language->lang_name;
                endif; ?>
                    <tr>
                        <td>
                            <a href="<?php echo Route::_('index.php?option=com_bwtransifex&view=language&zip=' . $language->id.'&project='.$this->item->id); ?>" data-test="project-lang-link-<?php echo $language->lang_name; ?>">
                                <?php echo $linkText; ?>
                            </a>
                        </td>
                        <td class="progress-col" data-test="project-lang-progress-<?php echo $language->lang_name; ?>">
                            <div class="progress progress-striped" style="margin-bottom: 0;">
                                <div class="bar" style="width: <?php echo $language->completed; ?>%;"></div>
                            </div>
                        </td>
                        <td data-test="project-lang-completed-<?php echo $language->lang_name; ?>">
                            <?php echo $language->completed; ?>%
                        </td>
                    </tr>
                <?php endforeach; ?>
            </table>
            <?php }
            else { ?>
                <div class="bwtx-no-langs" data-test="project-no-lang">
                    <?php echo Text::_('COM_BWTRANSIFEX_MO_TRANSLATIONS_FOR_PROJECT'); ?>
                </div>
        <?php } ?>

    </div>
</div>
<?php }
echo LayoutHelper::render('footer', array(), JPATH_SITE . '/components/com_bwtransifex/layouts/footer'); ?>
