<?php
/**
 * BwTransifex Component
 *
 * BwTransifex template 'Projects' for the component frontend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Site
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;

// Get provided style file
$app = Factory::getApplication();
$wa  = $app->getDocument()->getWebAssetManager();

$wa->useStyle('com_bwtransifex.bwtransifex_site');

// Get user defined style file
$templateName = $app->getTemplate();
$css_filename = 'templates/' . $templateName . '/css/com_bwtransifex.css';

if (file_exists(JPATH_BASE . '/' . $css_filename))
{
    $wa->registerAndUseStyle('customCss', Uri::root() . $css_filename);
}

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$limitstart	= $this->escape($this->state->get('list.start'));
$moduleId	= $this->escape($this->state->get('module.id', null));

//$actionSuffix = '&Itemid=' . $this->Itemid;
//
//if ($moduleId !== null && $moduleId !== '')
//{
//    $actionSuffix = '&mid=' . $moduleId;
//}

?>

<div id="bwtransifex" class="mt">
    <div id="bw_com_projects">
        <?php if (($this->params->get('show_page_heading', '0') != 0) && ($this->params->get('page_heading', '') != '')) : ?>
            <h1 class="componentheading<?php echo $this->params->get('pageclass_sfx', ''); ?>" data-test="projects-entry-page-heading">
                <?php echo $this->escape($this->params->get('page_heading', '')); ?>
            </h1>
        <?php endif; ?>

        <form action="<?php echo Route::_('index.php?option=com_bwtransifex&view=projects'); ?>" method="post"
            name="adminForm" id="adminForm">
            <div id="bw-projects-list<?php echo $this->params->get('pageclass_sfx', '');?>" data-test="projects-list">
                <h2>
                    <?php echo Text::_('COM_BWTRANSIFEX_VIEW_PROJECTS_LIST_TITLE'); ?>
                </h2>
                <?php
                if (count($this->items) > 0)
                {
                foreach ($this->items as $i => $item) : ?>
                <?php $projectName = str_replace(' ', '_', $item->title); ?>
                <?php $url = Route::_('index.php?option=com_bwtransifex&view=project&id=' . $item->id); ?>
                <section id="<?php echo $projectName; ?>" data-test="projects-entry-section-<?php echo $projectName;?>">
                    <h2 data-test="projects-entry-header-<?php echo $projectName; ?>">
                        <a href="<?php echo $url; ?>" data-test="projects-entry-header-link-<?php echo $projectName; ?>">
                            <?php echo $item->title; ?>
                        </a>
                    </h2>

                    <div data-test="projects-entry-desc-<?php echo $projectName; ?>">
                        <?php echo $item->description; ?>
                    </div>
                    <a class="btn" href="<?php echo $url; ?>" data-test="projects-entry-link-<?php echo $projectName; ?>">
                        <?php echo Text::_('COM_BWTRANSIFEX_VIEW_AVAILABLE_TRANSLATIONS'); ?>
                    </a>
                    <hr/>
                </section>
                <?php endforeach;
                }
                else
                { ?>
                <section class="bwtx-no-entries">
                    <p><?php echo Text::_('COM_BWTRANSIFEX_NO_PROJECTS_FOUND'); ?></p> <?php
                    } ?>
                </section>
            </div>

            <?php
            if ($this->pagination->pagesTotal > 1)
            { ?>
                <div class="pagination">
                    <?php echo $this->pagination->getPagesLinks(); ?>
                    <p class="counter"><?php echo $this->pagination->getPagesCounter(); ?> </p>
                </div>
                <?php
            } ?>

            <input type="hidden" name="option" value="com_bwtransifex" />
            <input type="hidden" name="task" value="" />
            <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
            <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
            <input type="hidden" name="limitstart" value="<?php echo $limitstart; ?>" />
            <input type="hidden" name="id" value="" />
            <?php echo HtmlHelper::_('form.token'); ?>
        </form>

        <?php
        echo LayoutHelper::render('footer', array(), JPATH_SITE . '/components/com_bwtransifex/layouts/footer'); ?>
    </div>
</div>
